<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Docs;

class InlineObject extends \Google\Collection
{
  protected $collection_key = 'suggestedDeletionIds';
  protected $inlineObjectPropertiesType = InlineObjectProperties::class;
  protected $inlineObjectPropertiesDataType = '';
  public $inlineObjectProperties;
  /**
   * @var string
   */
  public $objectId;
  /**
   * @var string[]
   */
  public $suggestedDeletionIds;
  protected $suggestedInlineObjectPropertiesChangesType = SuggestedInlineObjectProperties::class;
  protected $suggestedInlineObjectPropertiesChangesDataType = 'map';
  public $suggestedInlineObjectPropertiesChanges;
  /**
   * @var string
   */
  public $suggestedInsertionId;

  /**
   * @param InlineObjectProperties
   */
  public function setInlineObjectProperties(InlineObjectProperties $inlineObjectProperties)
  {
    $this->inlineObjectProperties = $inlineObjectProperties;
  }
  /**
   * @return InlineObjectProperties
   */
  public function getInlineObjectProperties()
  {
    return $this->inlineObjectProperties;
  }
  /**
   * @param string
   */
  public function setObjectId($objectId)
  {
    $this->objectId = $objectId;
  }
  /**
   * @return string
   */
  public function getObjectId()
  {
    return $this->objectId;
  }
  /**
   * @param string[]
   */
  public function setSuggestedDeletionIds($suggestedDeletionIds)
  {
    $this->suggestedDeletionIds = $suggestedDeletionIds;
  }
  /**
   * @return string[]
   */
  public function getSuggestedDeletionIds()
  {
    return $this->suggestedDeletionIds;
  }
  /**
   * @param SuggestedInlineObjectProperties[]
   */
  public function setSuggestedInlineObjectPropertiesChanges($suggestedInlineObjectPropertiesChanges)
  {
    $this->suggestedInlineObjectPropertiesChanges = $suggestedInlineObjectPropertiesChanges;
  }
  /**
   * @return SuggestedInlineObjectProperties[]
   */
  public function getSuggestedInlineObjectPropertiesChanges()
  {
    return $this->suggestedInlineObjectPropertiesChanges;
  }
  /**
   * @param string
   */
  public function setSuggestedInsertionId($suggestedInsertionId)
  {
    $this->suggestedInsertionId = $suggestedInsertionId;
  }
  /**
   * @return string
   */
  public function getSuggestedInsertionId()
  {
    return $this->suggestedInsertionId;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(InlineObject::class, 'Google_Service_Docs_InlineObject');
